/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.api.types.ILivestock;
import net.dries007.tfc.network.PacketSimpleMessage;
import net.dries007.tfc.objects.LootTablesTFC;
import net.dries007.tfc.objects.entity.EntitiesTFC;
import net.dries007.tfc.objects.entity.animal.AnimalGroupingRules;
import net.dries007.tfc.objects.entity.animal.EntityAnimalMammal;
import net.dries007.tfc.objects.entity.animal.EntityAnimalTFC;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.climate.BiomeHelper;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@ParametersAreNonnullByDefault
public class EntitySheepTFC
extends EntityAnimalMammal
implements IShearable,
ILivestock {
    private static final DataParameter<Integer> DYE_COLOR = EntityDataManager.func_187226_a(EntitySheepTFC.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Long> SHEARED = EntityDataManager.func_187226_a(EntitySheepTFC.class, EntitiesTFC.getLongDataSerializer());

    public EntitySheepTFC(World worldIn) {
        this(worldIn, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), EntitySheepTFC.getRandomGrowth(ConfigTFC.Animals.SHEEP.adulthood, ConfigTFC.Animals.SHEEP.elder), EntitySheep.func_175510_a((Random)Constants.RNG));
    }

    public EntitySheepTFC(World worldIn, IAnimalTFC.Gender gender, int birthDay, EnumDyeColor dye) {
        super(worldIn, gender, birthDay);
        this.func_70105_a(0.9f, 1.3f);
        this.setDyeColor(dye);
        this.setShearedTick(0L);
    }

    @Override
    public int getSpawnWeight(Biome biome, float temperature, float rainfall, float floraDensity, float floraDiversity) {
        BiomeHelper.BiomeType biomeType = BiomeHelper.getBiomeType(temperature, rainfall, floraDensity);
        if (!BiomesTFC.isOceanicBiome(biome) && !BiomesTFC.isBeachBiome(biome) && biomeType == BiomeHelper.BiomeType.PLAINS) {
            return ConfigTFC.Animals.SHEEP.rarity;
        }
        return 0;
    }

    @Override
    public BiConsumer<List<EntityLiving>, Random> getGroupingRules() {
        return AnimalGroupingRules.MALE_AND_FEMALES;
    }

    @Override
    public int getMinGroupSize() {
        return 3;
    }

    @Override
    public int getMaxGroupSize() {
        return 5;
    }

    @Override
    public void birthChildren() {
        int numberOfChildren = ConfigTFC.Animals.SHEEP.babies;
        for (int i = 0; i < numberOfChildren; ++i) {
            EntitySheepTFC baby = new EntitySheepTFC(this.field_70170_p, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), (int)CalendarTFC.PLAYER_TIME.getTotalDays(), this.getDyeColor());
            baby.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
            baby.setFamiliarity(this.getFamiliarity() < 0.9f ? this.getFamiliarity() / 2.0f : this.getFamiliarity() * 0.9f);
            this.field_70170_p.func_72838_d((Entity)baby);
        }
    }

    @Override
    public long gestationDays() {
        return ConfigTFC.Animals.SHEEP.gestation;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DYE_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(SHEARED, (Object)0L);
    }

    @Override
    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74772_a("shearedTick", this.getShearedTick());
        compound.func_74768_a("dyecolor", this.getDyeColor().func_176765_a());
    }

    @Override
    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setShearedTick(compound.func_74763_f("shearedTick"));
        this.setDyeColor(EnumDyeColor.func_176764_b((int)compound.func_74771_c("dyecolor")));
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (OreDictionaryHelper.doesStackMatchOre(stack, "knife")) {
            if (!this.field_70170_p.field_72995_K) {
                if (this.isReadyForAnimalProduct()) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                    ItemStack woolStack = new ItemStack((Item)ItemsTFC.WOOL, 1);
                    Helpers.spawnItemStack(player.field_70170_p, new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), woolStack);
                    this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
                    this.setProductsCooldown();
                } else {
                    TextComponentTranslation tooltip = this.getTooltip();
                    if (tooltip != null) {
                        TerraFirmaCraft.getNetwork().sendTo((IMessage)new PacketSimpleMessage(PacketSimpleMessage.MessageCategory.ANIMAL, (ITextComponent)tooltip), (EntityPlayerMP)player);
                    }
                }
            }
            return true;
        }
        if (OreDictionaryHelper.doesStackMatchOre(stack, "shears")) {
            TextComponentTranslation tooltip;
            if (!this.field_70170_p.field_72995_K && !this.isReadyForAnimalProduct() && (tooltip = this.getTooltip()) != null) {
                TerraFirmaCraft.getNetwork().sendTo((IMessage)new PacketSimpleMessage(PacketSimpleMessage.MessageCategory.ANIMAL, (ITextComponent)tooltip), (EntityPlayerMP)player);
            }
            return false;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public double getOldDeathChance() {
        return ConfigTFC.Animals.SHEEP.oldDeathChance;
    }

    @Override
    protected boolean eatFood(@Nonnull ItemStack stack, EntityPlayer player) {
        IFood cap = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null);
        if (cap != null && cap.isRotten()) {
            return false;
        }
        return super.eatFood(stack, player);
    }

    @Override
    public float getAdultFamiliarityCap() {
        return 0.35f;
    }

    @Override
    public int getDaysToAdulthood() {
        return ConfigTFC.Animals.SHEEP.adulthood;
    }

    @Override
    public int getDaysToElderly() {
        return ConfigTFC.Animals.SHEEP.elder;
    }

    @Override
    public boolean isReadyForAnimalProduct() {
        return this.getAge() != IAnimalTFC.Age.CHILD && this.hasWool() && this.getFamiliarity() > 0.15f;
    }

    @Override
    public List<ItemStack> getProducts() {
        return Collections.singletonList(new ItemStack((Item)ItemsTFC.WOOL, 1));
    }

    @Override
    public void setProductsCooldown() {
        this.setShearedTick(CalendarTFC.PLAYER_TIME.getTicks());
    }

    @Override
    public long getProductsCooldown() {
        return Math.max(0L, (long)ConfigTFC.Animals.SHEEP.woolTicks + this.getShearedTick() - CalendarTFC.PLAYER_TIME.getTicks());
    }

    @Override
    public TextComponentTranslation getTooltip() {
        if (this.getAge() == IAnimalTFC.Age.CHILD) {
            return new TextComponentTranslation("tfc.tooltip.animal.product.young", new Object[]{this.getAnimalName()});
        }
        if (this.getFamiliarity() <= 0.15f) {
            return new TextComponentTranslation("tfc.tooltip.animal.product.low_familiarity", new Object[]{this.getAnimalName()});
        }
        if (!this.hasWool()) {
            return new TextComponentTranslation("tfc.tooltip.animal.product.no_wool", new Object[]{this.getAnimalName()});
        }
        return null;
    }

    public EnumDyeColor getDyeColor() {
        return EnumDyeColor.func_176764_b((int)((Integer)this.field_70180_af.func_187225_a(DYE_COLOR)));
    }

    public void setDyeColor(EnumDyeColor color) {
        this.field_70180_af.func_187227_b(DYE_COLOR, (Object)color.func_176765_a());
    }

    public boolean isShearable(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos) {
        return this.isReadyForAnimalProduct();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        this.setProductsCooldown();
        List<ItemStack> products = this.getProducts();
        int i = 1 + fortune + this.field_70146_Z.nextInt(3 - Math.min(2, fortune));
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (ItemStack stack : products) {
            stack.func_190920_e(i);
            ret.add(stack);
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }

    public long getShearedTick() {
        return (Long)this.field_70180_af.func_187225_a(SHEARED);
    }

    public void setShearedTick(long tick) {
        this.field_70180_af.func_187227_b(SHEARED, (Object)tick);
    }

    public boolean hasWool() {
        return this.getShearedTick() <= 0L || this.getProductsCooldown() <= 0L;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187761_eI;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187759_eH;
    }

    protected void func_184651_r() {
        EntityAnimalTFC.addCommonLivestockAI(this, 1.2);
        EntityAnimalTFC.addCommonPreyAI(this, 1.2);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187757_eG;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTablesTFC.ANIMALS_SHEEP;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }
}

